//----------------------------------------------------------------------------
//  Description:  This file contains definitions specific to the hardware board.
//  Specifically, the definitions include hardware connections with the
//  CCxxxx connector port, LEDs, and switches.
//
//  MSP430/CC1100-2500 Interface Code Library v1.0
//
//  K. Quiring
//  Texas Instruments, Inc.
//  July 2006
//  IAR Embedded Workbench v3.41
//----------------------------------------------------------------------------


#include "TI_CC_msp430.h"

//#define TI_CC_SW_PxIN           P1IN
//#define TI_CC_SW_PxIE           P1IE
//#define TI_CC_SW_PxIES          P1IES
//#define TI_CC_SW_PxIFG          P1IFG
//#define TI_CC_SW_PxREN          P1REN  //Pull-up, pull-down enable register
//#define TI_CC_SW_PxOUT          P1OUT  //Selecting pull-up or pull-down if enabled, otherwise output
//#define TI_CC_SW1               0x10
//#define TI_CC_SW2               0x20
//#define TI_CC_SW3               0x40
//#define TI_CC_SW4               0x80
//#define TI_CC_SW4               0x08   //Port1.3

#define TI_CC_GDO0_PxOUT        P2OUT
#define TI_CC_GDO0_PxIN         P2IN
#define TI_CC_GDO0_PxDIR        P2DIR
#define TI_CC_GDO0_PxIE         P2IE
#define TI_CC_GDO0_PxIES        P2IES
#define TI_CC_GDO0_PxIFG        P2IFG
//#define TI_CC_GDO0_PIN          0x10
#define TI_CC_GDO0_PIN          0x80   //Port2.7 - GDO0 - external interrupt

#define TI_CC_GDO1_PxOUT        P5OUT
#define TI_CC_GDO1_PxIN         P5IN
#define TI_CC_GDO1_PxDIR        P5DIR
#define TI_CC_GDO1_PIN          0x04

#define TI_CC_GDO2_PxOUT        P2OUT
#define TI_CC_GDO2_PxIN         P2IN
#define TI_CC_GDO2_PxDIR        P2DIR
#define TI_CC_GDO2_PIN          0x40

//#define TI_CC_CSn_PxOUT         P5OUT
//#define TI_CC_CSn_PxDIR         P5DIR
//#define TI_CC_CSn_PIN           0x01

#define LED_PxOUT         P1OUT
#define LED_PxDIR         P1DIR
#define LED              0x02   //Port1.3

#define TI_CC_CSn_PxOUT         P1OUT   //Port1 output register
#define TI_CC_CSn_PxDIR         P1DIR   //Port1 direction register
#define TI_CC_CSn_PIN           0x10   //Port1.3 - nCS

//----------------------------------------------------------------------------
// Select which port will be used for interface to CCxxxx
//----------------------------------------------------------------------------
//#define TI_CC_RF_SER_INTF       TI_CC_SER_INTF_USART1  // Interface to CCxxxx
#define TI_CC_RF_SER_INTF       TI_CC_SER_INTF_USI  // USI interface to CCxxxx
